/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.designer;

import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.vw.apps.designer.images.VWImageLoader;
import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.event.VWToolbarMouseAdapter;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class VWSIMDesignerStatusBar
extends JPanel
implements ItemListener {
    private JTextField m_filenameTextField = null;
    private JTextField m_msgTextField = null;
    private JCheckBox m_stepNamesCheckBox = null;
    private JCheckBox m_routeNamesCheckBox = null;
    private JCheckBox m_milestoneAttrsCheckBox = null;
    private JCheckBox m_conditionAttrsCheckBox = null;
    private JCheckBox m_collectorAttrsCheckBox = null;
    private VWMapAttribs m_mapAttribs = null;

    public VWSIMDesignerStatusBar(VWSIMPropertyData propertyData, VWMapAttribs mapAttribs) {
        this.m_mapAttribs = mapAttribs;
        this.init();
        this.addMouseListener(new VWToolbarMouseAdapter(this, 7, propertyData.getToolbarActionNotifier()));
    }

    public String getFilename() {
        return this.m_filenameTextField.getText();
    }

    public void setFilename(String filename) {
        this.m_filenameTextField.setText(filename);
    }

    public void setMessage(String msg) {
        this.m_msgTextField.setText(msg);
    }

    public void releaseReferences() {
        this.m_filenameTextField = null;
        this.m_msgTextField = null;
        this.m_stepNamesCheckBox = null;
        this.m_routeNamesCheckBox = null;
        this.m_milestoneAttrsCheckBox = null;
        this.m_conditionAttrsCheckBox = null;
        this.m_collectorAttrsCheckBox = null;
        this.m_mapAttribs = null;
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.m_mapAttribs != null) {
            boolean bShow;
            Object src = event.getSource();
            int state = event.getStateChange();
            boolean bl = bShow = state == 1;
            if (src == this.m_stepNamesCheckBox) {
                this.m_mapAttribs.setStepNameVisible(bShow);
            } else if (src == this.m_routeNamesCheckBox) {
                this.m_mapAttribs.setRouteNameVisible(bShow);
            } else if (src == this.m_milestoneAttrsCheckBox) {
                this.m_mapAttribs.setMilestoneVisible(bShow);
            } else if (src == this.m_conditionAttrsCheckBox) {
                this.m_mapAttribs.setConditionAttrsVisible(bShow);
            } else if (src == this.m_collectorAttrsCheckBox) {
                this.m_mapAttribs.setCollectorAttrsVisible(bShow);
            }
        }
    }

    private void init() {
        try {
            this.setLayout(new GridBagLayout());
            JPanel panel = new JPanel(new BorderLayout(0, 0));
            panel.setBorder(BorderFactory.createLoweredBevelBorder());
            this.m_filenameTextField = new JTextField();
            this.m_filenameTextField.setEditable(false);
            this.m_filenameTextField.setBackground(this.getBackground());
            this.m_filenameTextField.setBorder(null);
            panel.add((Component)new JLabel(" "), "Before");
            panel.add((Component)this.m_filenameTextField, "Center");
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.weightx = 0.6;
            gbCons.weighty = 0.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 0, 0, 0);
            gbCons.anchor = 21;
            gbCons.fill = 1;
            this.add((Component)panel, gbCons);
            panel = new JPanel(new BorderLayout(0, 0));
            panel.setBorder(BorderFactory.createLoweredBevelBorder());
            this.m_msgTextField = new JTextField();
            this.m_msgTextField.setEditable(false);
            this.m_msgTextField.setBorder(null);
            this.m_msgTextField.setBackground(this.getBackground());
            panel.add((Component)new JLabel(" "), "Before");
            panel.add((Component)this.m_msgTextField, "Center");
            ++gbCons.gridx;
            gbCons.weightx = 0.4;
            this.add((Component)panel, gbCons);
            panel = new JPanel(new FlowLayout(1, 1, 0));
            panel.setBorder(BorderFactory.createLoweredBevelBorder());
            panel.add(new JLabel(" "));
            this.m_stepNamesCheckBox = new JCheckBox(VWImageLoader.createImageIcon("step_hide.gif"));
            this.m_stepNamesCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("step_show.gif"));
            this.m_stepNamesCheckBox.setToolTipText(VWResource.s_showHideStepNamesStr);
            this.m_stepNamesCheckBox.setSelected(true);
            this.m_stepNamesCheckBox.addItemListener(this);
            panel.add(this.m_stepNamesCheckBox);
            this.m_routeNamesCheckBox = new JCheckBox(VWImageLoader.createImageIcon("route_hide.gif"));
            this.m_routeNamesCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("route_show.gif"));
            this.m_routeNamesCheckBox.setToolTipText(VWResource.s_showHideRouteNamesStr);
            this.m_routeNamesCheckBox.setSelected(true);
            this.m_routeNamesCheckBox.addItemListener(this);
            panel.add(this.m_routeNamesCheckBox);
            this.m_milestoneAttrsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("milestone_hide.gif"));
            this.m_milestoneAttrsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("milestone_show.gif"));
            this.m_milestoneAttrsCheckBox.setToolTipText(VWResource.s_showHideMilestoneAttributesStr);
            this.m_milestoneAttrsCheckBox.setSelected(true);
            this.m_milestoneAttrsCheckBox.addItemListener(this);
            panel.add(this.m_milestoneAttrsCheckBox);
            this.m_conditionAttrsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("condition_hide.gif"));
            this.m_conditionAttrsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("condition_show.gif"));
            this.m_conditionAttrsCheckBox.setToolTipText(VWResource.s_showHideConditionAttributesStr);
            this.m_conditionAttrsCheckBox.setSelected(true);
            this.m_conditionAttrsCheckBox.addItemListener(this);
            panel.add(this.m_conditionAttrsCheckBox);
            this.m_collectorAttrsCheckBox = new JCheckBox(VWImageLoader.createImageIcon("collector_hide.gif"));
            this.m_collectorAttrsCheckBox.setSelectedIcon(VWImageLoader.createImageIcon("collector_show.gif"));
            this.m_collectorAttrsCheckBox.setToolTipText(VWResource.s_showHideCollectorAttributesStr);
            this.m_collectorAttrsCheckBox.setSelected(true);
            this.m_collectorAttrsCheckBox.addItemListener(this);
            panel.add(this.m_collectorAttrsCheckBox);
            ++gbCons.gridx;
            gbCons.weightx = 0.0;
            gbCons.fill = 0;
            this.add((Component)panel, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

